using System;
/*****************************************************************/
/* Tokenworks PDF417 and Magnetic Stripe Parsing Library        */
/*  Copyright 2009, TokenWorks Inc.                      */
/* All rights reserved.                                          */
/* Redistribution and use of this code in source and/or binary   */
/* forms, with or without modification, are permitted provided   */
/* that: (1) all copies of the source code retain the above      */
/* unmodified copyright notice and this entire unmodified        */
/* section of text, (2) You or Your organization owns a valid    */
/* Developer License to this product from TokenWorks Inc.       */
/* and, (3) when any portion of this code is bundled in any      */
/* form with an application, a valid notice must be provided     */
/* within the user documentation, start-up screen or in the      */
/* help-about section of the application that specifies          */
/* TokenWorks as the provider of the Software bundled      */
/* with the application.                                         */
/*****************************************************************/


namespace BuffMgr
{
	/// <summary>
	/// Summary description for ReaderBuffMgr.
	/// This class manages the data coming from the reader based on a time stamp.
	/// </summary>
	public class ReaderBuffMgr
	{
		
		static public string StrBuffASCII = "";  // Hold current input data from reader in ASCII format 
        static public byte[] RawBytes=new byte[2000];	// Holds current input data in byte array
        public static int count = 0;
        public static int PrevLng=0;
		private static int PreviousTimeStamp = 0;		// Holds previous reader response time stampe

		public static void ScanBuilder(string StrLatestData, int IntTickTime)
		{
			// If time stamp close to previous time stamp, concatenate the latest data with the previous data
			if ((IntTickTime - PreviousTimeStamp) <= 901)

			{
                StrBuffASCII += StrLatestData;
			}

			else  // Else, flush the data and start fresh with latest string data
			{
                StrBuffASCII = StrLatestData;
			}

			GetTimeStamp();	//Update Time Stamp Value
		}


        public static void DataBuilder(byte[]buffer, int IntTickTime)
        {
            // If time stamp close to previous time stamp, concatenate the latest data with the previous data
            if ((IntTickTime - PreviousTimeStamp) <= 901)
            {
                if (count == 0)
                {
                    Array.Copy(buffer, 0, RawBytes, 0, buffer.Length);
                    PrevLng += buffer.Length;//PrevLng s/b 0
                }
                if (count >0)
                {
                    Array.Copy(buffer, 0, RawBytes, PrevLng, buffer.Length);
                    PrevLng += buffer.Length;
                }
                count++;
            }
            else  // Else, flush the data and start fresh with latest string data
            {

                Array.Copy(buffer, 0, RawBytes, 0, buffer.Length);
                PrevLng =buffer.Length;//PrevLng s/b 0
                count++;
            }
            GetTimeStamp();	//Update Time Stamp Value
        }



		public static void GetTimeStamp()
		{
		PreviousTimeStamp =	Environment.TickCount;
		}
	}
}
